import java.io.*;
import java.util.*;
/*
*	Represents a stock item
*
*/


public class StockItem implements Serializable, Cloneable{
  private String serialNo;		//Stock id
  private String description;		//Descriptio of item
  private int stock;			//Qty in stock
  private String location;		//location eg: warehouse 1, warehouse 2 etc
  private ArrayList history = new ArrayList(); //Keeps a list of Strings which make up a record of transactions


  public StockItem(String serialNo, String desc, int stock, String location){
    this.serialNo = serialNo;
    this.description = desc;
    this.stock = stock;
    this.location = location;
    }

  public String getserialNo(){
    return serialNo;
    }

  public String getHistory(){
    return this.toString()+"\n"+history.toString();
    }

  public double getStock(){
    return stock;
    }

  public boolean addStock(int amt, String dateTime){
  /*
  Assume some new stock has been delivered. Update the quantity and add a note in the history list
  */
    if (amt < 0)
      return false;
    stock = stock + amt;
    history.add(new String("Recieved "+dateTime+" \tQty="+amt+"\tTot. Stock "+stock+"\n"));  
    return true;
    }

  public boolean debitStock(int amt, String dateTime){
  /*
  Remove some stock, update the quantity and add a note in the history list
  */ 
    if ((stock-amt) < 0)
      return false;
    stock = stock - amt;
    history.add(new String("Sold "+dateTime+" \tQty"+amt+"\tTot. Stock"+stock+"\n"));
    return true;
    }

  public String toString(){
    return serialNo + "\t Desc\t" +description+"\n Current stock" + stock +"\t Location "+location;
    }

  public Object clone(){
  /*
  Used to make a copy or "clone" the object
  */
  try{
    return super.clone();
    }
  catch (Exception e){
    System.out.println("Error " +e  );
    System.exit(-1);
    }
  return null;
  }
}